/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.element;

import com.terraforged.mod.client.gui.element.Element;
import com.terraforged.mod.client.gui.element.TFButton;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TFToggle
extends TFButton {
    private final boolean noname;
    private final String prefix;
    private final String name;
    private final CompoundNBT value;
    private final ListNBT options;
    private final List<String> tooltip;
    private int index;
    private Runnable callback = () -> {};

    public TFToggle(String name, CompoundNBT value) {
        super(value.func_74779_i(name));
        this.name = name;
        this.value = value;
        this.prefix = Element.getDisplayName(name, value) + ": ";
        this.tooltip = Element.getToolTip(name, value);
        INBT selected = value.func_74781_a(name);
        CompoundNBT meta = value.func_74775_l('#' + name);
        this.noname = meta.func_74764_b("noname");
        this.options = (ListNBT)meta.func_74781_a("options");
        Objects.requireNonNull(this.options, "Missing options list");
        for (int i = 0; i < this.options.size(); ++i) {
            INBT s = this.options.get(i);
            if (!s.equals(selected)) continue;
            this.index = i;
            break;
        }
        if (this.noname) {
            this.func_238482_a_((ITextComponent)new StringTextComponent(TFToggle.toString(value.func_74781_a(name))));
        } else {
            this.func_238482_a_((ITextComponent)new StringTextComponent(this.prefix + TFToggle.toString(value.func_74781_a(name))));
        }
    }

    public TFToggle callback(Runnable runnable) {
        this.callback = runnable;
        return this;
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }

    public boolean func_231044_a_(double mx, double my, int button) {
        if (this.func_230987_a_(button)) {
            int direction = button == 0 ? 1 : -1;
            this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            this.onClick(mx, my, direction);
            return true;
        }
        return false;
    }

    protected boolean func_230987_a_(int button) {
        return button == 0 || button == 1;
    }

    private void onClick(double mouseX, double mouseY, int direction) {
        super.func_230982_a_(mouseX, mouseY);
        INBT option = this.options.get(this.increment(direction));
        this.value.func_218657_a(this.name, option);
        if (this.noname) {
            this.func_238482_a_((ITextComponent)new StringTextComponent(TFToggle.toString(option)));
        } else {
            this.func_238482_a_((ITextComponent)new StringTextComponent(this.prefix + TFToggle.toString(option)));
        }
        this.callback.run();
    }

    private int increment(int direction) {
        this.index += direction;
        if (this.index >= this.options.size()) {
            this.index = 0;
        } else if (this.index < 0) {
            this.index = this.options.size() - 1;
        }
        return this.index;
    }

    private static String toString(INBT nbt) {
        if (nbt == null) {
            return "null";
        }
        if (nbt.func_74732_a() == 1) {
            return ((ByteNBT)nbt).func_150290_f() == 1 ? "true" : "false";
        }
        return nbt.func_150285_a_();
    }
}

